function  C = clusteringCoefficient(obj,varargin)
%CLUSTERINGCOEFFICIENT Calculate the clustering coefficient for an
%AdjacencyMatrix object
%CC = clusteringCoefficient(adjMat)
%
%   Reference: Fagiolo, Clustering in complex directed networks


[A labels] = getSquareMatrix(obj);

% Set default parameter values
binary = true;
tolerance = 5;
calcP = false;
for k = 1:length(varargin)
    switch varargin{k}
        case 'weighted'
            binary = false;
        case 'threshold'
            tolerance = varargin{k+1};
        case 'pTest'
            calcP = true;
    end
end

if binary
    % Convert A to boolean graph, with tolerance given
    A(A<tolerance) = 0;
    A = double(A>0);
end

% Clear self-loops
A(logical(eye(size(A)))) = 0;

% Convert weighted matrix A so that all weights lie between 0 and 1
A = A./max(A(:));

CC = symmetrizedCCCalculation(A);
labels(isnan(CC)) = [];
CC = CC(~isnan(CC));

C = sum(CC)/numel(CC);

% [vals idxs] = sort(CC,'descend');
% fprintf('Neurons with highest clustering coefficients (symmetrized):\n');
% for i = 1:5
%     fprintf('%s %.4f\n',labels{idxs(i)},vals(i));
% end


fprintf('\nOverall clustering coefficient: %.4f\n',C);

% Perform statistical comparison to random graphs
if calcP
    nIters = 200;
    Crand = zeros(nIters,1);
    for i = 1:nIters
        Arand = randmio_dir_connected(A,20);  %rewire A
        Arand(logical(eye(size(Arand)))) = 0;
        CCtmp = symmetrizedCCCalculation(Arand);
        CCtmp = CCtmp(~isnan(CCtmp));
        Crand(i) = sum(CCtmp)/numel(CCtmp,1);
    end
    
    hist(Crand);
    pVal = sum(Crand > C) / nIters;
    fprintf('Mean clustering coefficient of randomly rewired graphs: %.4f\n',mean(Crand));
    fprintf('p-value for clustering coefficient: %f\n',pVal);
end

% Now perform analysis of directed motifs
% tcyc = diag(A^3);
% tmid = diag(A*A'*A);
% tin = diag(A'*A^2);
% tout = diag(A^2*A');

    function CC = symmetrizedCCCalculation(A)
        
        % Perform symmetrized calculation
        CC = zeros(size(A,1),1);
        selfDeg = A^2;
        symA = ((A.^(1/3)+(A.^(1/3))')^3);
        totDeg = sum(A,2)+sum(A,1)';
        
        for i = 1:size(A,1)
            
            if totDeg(i) == 0
                CC(i) = NaN;
                continue
            end
            CC(i) = symA(i,i)./(2*(totDeg(i)*(totDeg(i)-1)-2*(selfDeg(i,i))));
        end
    end
end